/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.Messages;
import com.aptana.core.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Plugin;

public final class URLEncoder {
    private URLEncoder() {
    }

    public static URL encode(URL url) throws MalformedURLException {
        try {
            String auth = url.getAuthority();
            String host = url.getHost();
            int port = url.getPort();
            if (StringUtil.isEmpty(auth) || auth.equals(host) && port == -1 || auth.equals(String.valueOf(host) + ":" + port)) {
                URI uri = new URI(url.getProtocol(), null, host, port, url.getPath(), url.getQuery(), url.getRef());
                return uri.toURL();
            }
        }
        catch (URISyntaxException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), String.valueOf(Messages.URLEncoder_Cannot_Encode_URL) + url, e);
        }
        return url;
    }

    public static String encode(String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(path, "/", true);
        while (tok.hasMoreTokens()) {
            String segment = tok.nextToken();
            if (segment.length() == 1 && segment.charAt(0) == '/') {
                sb.append(segment);
                continue;
            }
            sb.append(URLEncoder.encodeSegment(segment));
        }
        if (!StringUtil.isEmpty(query)) {
            sb.append('?').append(query);
        }
        if (!StringUtil.isEmpty(fragment)) {
            sb.append('#').append(URLEncoder.encodeSegment(fragment));
        }
        return sb.toString();
    }

    private static String encodeSegment(String segment) {
        char[] chars;
        int index = segment.indexOf(37);
        if (index != -1 && index + 1 < segment.length() && Character.isDigit(segment.charAt(index + 1))) {
            return segment;
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = chars = segment.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= ',' && ch <= ':' || ch == '~' || ch == '_' || ch == '!' || ch == '$') {
                sb.append(ch);
            } else {
                try {
                    byte[] bytes;
                    byte[] byArray = bytes = Character.toString(ch).getBytes("UTF8");
                    int n3 = bytes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        byte b = byArray[n4];
                        sb.append('%').append(Integer.toHexString(b >> 4 & 0xF)).append(Integer.toHexString(b & 0xF));
                        ++n4;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return sb.toString();
    }
}

